/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.Setup;
import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.inventory.AltarInventory;
import com.almostreliable.summoningrituals.network.IPacket;
import com.almostreliable.summoningrituals.network.PacketHandler;
import com.almostreliable.summoningrituals.network.packet.ProcessTimeUpdatePacket;
import com.almostreliable.summoningrituals.network.packet.ProgressUpdatePacket;
import com.almostreliable.summoningrituals.network.packet.SacrificeParticlePacket;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.recipe.component.RecipeSacrifices;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.almostreliable.summoningrituals.util.Observable;
import com.almostreliable.summoningrituals.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class AltarEntity
extends BlockEntity {
    public static final Observable SUMMONING_START = new Observable();
    public static final Observable SUMMONING_COMPLETE = new Observable();
    final AltarInventory inventory = new AltarInventory(this);
    private final LazyOptional<AltarInventory> inventoryCap = LazyOptional.of(() -> this.inventory);
    @Nullable
    private AltarRecipe currentRecipe;
    @Nullable
    private List<EntitySacrifice> sacrifices;
    @Nullable
    private ServerPlayer invokingPlayer;
    private int progress;
    private int processTime;

    public AltarEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Setup.ALTAR_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ItemStack handleInteraction(@Nullable ServerPlayer player, ItemStack stack) {
        if (this.progress > 0) {
            TextUtils.sendPlayerMessage((Player)player, "progress", ChatFormatting.RED, new Object[0]);
            return stack;
        }
        if (stack.m_41619_()) {
            if (player != null && player.m_6144_()) {
                this.inventory.popLastInserted();
            }
            return ItemStack.f_41583_;
        }
        if (AltarRecipe.CATALYST_CACHE.stream().anyMatch(ingredient -> ingredient.test(stack))) {
            this.inventory.setCatalyst(new ItemStack((ItemLike)stack.m_41720_(), 1));
            AltarRecipe recipe = this.findRecipe();
            if (recipe == null) {
                this.inventory.setCatalyst(ItemStack.f_41583_);
            } else {
                ItemStack result;
                stack.m_41774_(1);
                ItemStack itemStack = result = stack.m_41619_() ? ItemStack.f_41583_ : stack;
                if (player != null) {
                    player.m_21008_(InteractionHand.MAIN_HAND, result);
                }
                this.handleSummoning(recipe, player);
                return result;
            }
        }
        ItemStack remaining = this.inventory.handleInsertion(stack);
        GameUtils.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_12019_);
        if (player != null) {
            player.m_21008_(InteractionHand.MAIN_HAND, remaining);
        }
        return remaining;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) && this.progress == 0) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    void playerDestroy(boolean creative) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        this.inventory.dropContents();
        if (creative) {
            return;
        }
        GameUtils.dropItem(this.f_58857_, this.f_58858_, new ItemStack((ItemLike)Setup.ALTAR_ITEM.get()), true);
    }

    void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.inventory.getCatalyst().m_41619_() && this.currentRecipe == null) {
            AltarRecipe recipe = this.findRecipe();
            if (recipe == null) {
                this.resetSummoning(true);
                return;
            }
            this.handleSummoning(recipe, null);
        }
        if (this.currentRecipe == null) {
            return;
        }
        if (this.progress >= this.currentRecipe.getRecipeTime()) {
            if (this.inventory.handleRecipe(this.currentRecipe)) {
                this.currentRecipe.getOutputs().handleRecipe((ServerLevel)this.f_58857_, this.f_58858_);
                SUMMONING_COMPLETE.invoke(this.f_58857_, this.f_58858_, this.currentRecipe, this.invokingPlayer);
                GameUtils.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11871_);
                this.resetSummoning(false);
            } else {
                TextUtils.sendPlayerMessage((Player)this.invokingPlayer, "invalid", ChatFormatting.RED, new Object[0]);
                this.resetSummoning(true);
            }
            return;
        }
        if (this.progress == 0) {
            this.changeActivityState(true);
            if (this.sacrifices != null && !this.sacrifices.isEmpty()) {
                this.sacrifices.stream().map(EntitySacrifice::kill).filter(positions -> !positions.isEmpty()).forEach(positions -> this.trackingChunkPacket(new SacrificeParticlePacket((List<BlockPos>)positions)));
            }
        }
        ++this.progress;
        this.trackingChunkPacket(new ProgressUpdatePacket(this.f_58858_, this.progress));
    }

    private void resetSummoning(boolean popLastInserted) {
        this.currentRecipe = null;
        this.sacrifices = null;
        this.invokingPlayer = null;
        this.progress = 0;
        this.trackingChunkPacket(new ProgressUpdatePacket(this.f_58858_, this.progress));
        this.processTime = 0;
        this.trackingChunkPacket(new ProcessTimeUpdatePacket(this.f_58858_, this.processTime));
        this.changeActivityState(false);
        if (popLastInserted) {
            this.inventory.popLastInserted();
        }
    }

    private void trackingChunkPacket(IPacket<?> packet) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), packet);
    }

    private void handleSummoning(AltarRecipe recipe, @Nullable ServerPlayer player) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        this.sacrifices = this.checkSacrifices(recipe.getSacrifices(), player);
        if (!(this.sacrifices != null && this.checkBlockBelow(recipe.getBlockBelow(), player) && recipe.getDayTime().check(this.f_58857_, player) && recipe.getWeather().check(this.f_58857_, player))) {
            this.inventory.popLastInserted();
            GameUtils.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11794_);
            return;
        }
        if (!SUMMONING_START.invoke(this.f_58857_, this.f_58858_, recipe, player)) {
            this.resetSummoning(true);
            return;
        }
        this.currentRecipe = recipe;
        this.invokingPlayer = player;
        this.processTime = recipe.getRecipeTime();
        GameUtils.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11736_);
        this.trackingChunkPacket(new ProcessTimeUpdatePacket(this.f_58858_, this.processTime));
    }

    @Nullable
    private AltarRecipe findRecipe() {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        RecipeManager recipeManager = GameUtils.getRecipeManager(this.f_58857_);
        return recipeManager.m_44015_((RecipeType)Setup.ALTAR_RECIPE.type().get(), (Container)this.inventory.getVanillaInv(), this.f_58857_).orElse(null);
    }

    @Nullable
    private List<EntitySacrifice> checkSacrifices(RecipeSacrifices sacrifices, @Nullable ServerPlayer player) {
        ArrayList<EntitySacrifice> toKill;
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        if (sacrifices.isEmpty()) {
            return List.of();
        }
        AABB region = sacrifices.getRegion(this.f_58858_);
        List entities = this.f_58857_.m_45933_((Entity)player, region);
        boolean success = sacrifices.test(arg_0 -> AltarEntity.lambda$checkSacrifices$5(entities, player, toKill = new ArrayList<EntitySacrifice>(), arg_0));
        return success ? toKill : null;
    }

    private boolean checkBlockBelow(@Nullable BlockReference blockBelow, @Nullable ServerPlayer player) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        if (blockBelow == null || blockBelow.test(this.f_58857_.m_8055_(this.f_58858_.m_7495_()))) {
            return true;
        }
        TextUtils.sendPlayerMessage((Player)player, "block_below", ChatFormatting.YELLOW, new Object[0]);
        return false;
    }

    private void changeActivityState(boolean state) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState oldState = this.f_58857_.m_8055_(this.f_58858_);
        if (!((Boolean)oldState.m_61143_((Property)AltarBlock.ACTIVE)).equals(state)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)oldState.m_61124_((Property)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(state)));
        }
    }

    int getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(int processTime) {
        this.processTime = processTime;
    }

    int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private static /* synthetic */ boolean lambda$checkSacrifices$5(List entities, ServerPlayer player, List toKill, RecipeSacrifices.Sacrifice sacrifice) {
        List<Entity> found = entities.stream().filter(sacrifice).toList();
        if (found.size() < sacrifice.count()) {
            TextUtils.sendPlayerMessage((Player)player, "sacrifices", ChatFormatting.YELLOW, new Object[0]);
            return false;
        }
        toKill.add(new EntitySacrifice(found, sacrifice.count()));
        return true;
    }

    private record EntitySacrifice(List<Entity> entities, int count) {
        private List<BlockPos> kill() {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (int i = 0; i < this.count; ++i) {
                Entity entity = this.entities.get(i);
                entity.m_20049_(TextUtils.f("{}_sacrificed", "summoningrituals"));
                entity.m_6074_();
                positions.add(entity.m_142538_());
            }
            return positions;
        }
    }
}

